/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.task;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.gui.task.RepeatedDelayStrategy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.util.TimeSource;
import org.slf4j.Logger;

public class DataFetcher {
    static final Logger LOGGER = LogUtils.getLogger();
    final Executor executor;
    final TimeUnit resolution;
    final TimeSource timeSource;

    public DataFetcher(Executor p_239381_, TimeUnit p_239382_, TimeSource p_239383_) {
        this.executor = p_239381_;
        this.resolution = p_239382_;
        this.timeSource = p_239383_;
    }

    public <T> Task<T> createTask(String p_239623_, Callable<T> p_239624_, Duration p_239625_, RepeatedDelayStrategy p_239626_) {
        long $$4 = this.resolution.convert(p_239625_);
        if ($$4 == 0L) {
            throw new IllegalArgumentException("Period of " + String.valueOf(p_239625_) + " too short for selected resolution of " + String.valueOf((Object)this.resolution));
        }
        return new Task<T>(p_239623_, p_239624_, $$4, p_239626_);
    }

    public Subscription createSubscription() {
        return new Subscription();
    }

    public class Task<T> {
        private final String id;
        private final Callable<T> updater;
        private final long period;
        private final RepeatedDelayStrategy repeatStrategy;
        @Nullable
        private CompletableFuture<ComputationResult<T>> pendingTask;
        @Nullable
        SuccessfulComputationResult<T> lastResult;
        private long nextUpdate = -1L;

        Task(String p_239074_, Callable<T> p_239075_, long p_239076_, RepeatedDelayStrategy p_239077_) {
            this.id = p_239074_;
            this.updater = p_239075_;
            this.period = p_239076_;
            this.repeatStrategy = p_239077_;
        }

        void updateIfNeeded(long p_239710_) {
            if (this.pendingTask != null) {
                ComputationResult $$1 = this.pendingTask.getNow(null);
                if ($$1 == null) {
                    return;
                }
                this.pendingTask = null;
                long $$2 = $$1.time;
                $$1.value().ifLeft(p_239691_ -> {
                    this.lastResult = new SuccessfulComputationResult<Object>(p_239691_, $$2);
                    this.nextUpdate = $$2 + this.period * this.repeatStrategy.delayCyclesAfterSuccess();
                }).ifRight(p_239281_ -> {
                    long $$2 = this.repeatStrategy.delayCyclesAfterFailure();
                    LOGGER.warn("Failed to process task {}, will repeat after {} cycles", new Object[]{this.id, $$2, p_239281_});
                    this.nextUpdate = $$2 + this.period * $$2;
                });
            }
            if (this.nextUpdate <= p_239710_) {
                this.pendingTask = CompletableFuture.supplyAsync(() -> {
                    try {
                        T $$0 = this.updater.call();
                        long $$1 = DataFetcher.this.timeSource.get(DataFetcher.this.resolution);
                        return new ComputationResult(Either.left($$0), $$1);
                    }
                    catch (Exception $$2) {
                        long $$3 = DataFetcher.this.timeSource.get(DataFetcher.this.resolution);
                        return new ComputationResult(Either.right((Object)$$2), $$3);
                    }
                }, DataFetcher.this.executor);
            }
        }

        public void reset() {
            this.pendingTask = null;
            this.lastResult = null;
            this.nextUpdate = -1L;
        }
    }

    public class Subscription {
        private final List<SubscribedTask<?>> subscriptions = new ArrayList();

        public <T> void subscribe(Task<T> p_239442_, Consumer<T> p_239443_) {
            SubscribedTask<T> $$2 = new SubscribedTask<T>(DataFetcher.this, p_239442_, p_239443_);
            this.subscriptions.add($$2);
            $$2.runCallbackIfNeeded();
        }

        public void forceUpdate() {
            for (SubscribedTask<?> $$0 : this.subscriptions) {
                $$0.runCallback();
            }
        }

        public void tick() {
            for (SubscribedTask<?> $$0 : this.subscriptions) {
                $$0.update(DataFetcher.this.timeSource.get(DataFetcher.this.resolution));
            }
        }

        public void reset() {
            for (SubscribedTask<?> $$0 : this.subscriptions) {
                $$0.reset();
            }
        }
    }

    class SubscribedTask<T> {
        private final Task<T> task;
        private final Consumer<T> output;
        private long lastCheckTime = -1L;

        SubscribedTask(DataFetcher dataFetcher, Task<T> p_239959_, Consumer<T> p_239960_) {
            this.task = p_239959_;
            this.output = p_239960_;
        }

        void update(long p_239226_) {
            this.task.updateIfNeeded(p_239226_);
            this.runCallbackIfNeeded();
        }

        void runCallbackIfNeeded() {
            SuccessfulComputationResult $$0 = this.task.lastResult;
            if ($$0 != null && this.lastCheckTime < $$0.time) {
                this.output.accept($$0.value);
                this.lastCheckTime = $$0.time;
            }
        }

        void runCallback() {
            SuccessfulComputationResult $$0 = this.task.lastResult;
            if ($$0 != null) {
                this.output.accept($$0.value);
                this.lastCheckTime = $$0.time;
            }
        }

        void reset() {
            this.task.reset();
            this.lastCheckTime = -1L;
        }
    }

    record SuccessfulComputationResult<T>(T value, long time) {
    }

    record ComputationResult<T>(Either<T, Exception> value, long time) {
    }
}

